/* --------------------------------------------------------------
   password_option.js 2020-02-26
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

gambio.widgets.module('password_option', [], function(data) {
	
	'use strict';
	
	var $this = $(this),
		$body = $('body'),
		$password_inputs = $('div.password-inputs'),
		defaults = {
		},
		options = $.extend(true, {}, defaults, data),
		module = {};
	
	// ########## HELPER FUNCTIONS ##########
	
	// (none)
	
	// ########## INITIALIZATION ##########
	
	/**
	 * Init function of the widget
	 * @constructor
	 */
	module.init = function(done) {
		let $passwordOption = $('#password-option');
		
		$passwordOption.on('change', function() {
			let isChecked = $(this).get(0).checked,
				$passwordInputs = $('div.password-inputs input[type="password"]');
			if(isChecked) {
				$password_inputs.show();
				$passwordInputs.each(function() {
					$(this).removeAttr('disabled');
				});
				$('button[type="submit"]', $this.closest('form')).attr('disabled', 'disabled');
			} else {
				$password_inputs.hide();
				$passwordInputs.each(function() {
					$(this).attr('disabled', 'disabled');
					$(this).val('');
				});
				$('button[type="submit"]', $this.closest('form')).removeAttr('disabled');
			}
		});

		let passwordChange = function() {
			let isChecked = $passwordOption.get(0) !== undefined ? $passwordOption.get(0).checked : true;
			if(isChecked) {
				let inputsMatch = $('#password').val().length >= 0 && ($('#password').val() === $('#confirmation').val()),
					$noMatchNote = $('span.password-no-match');
				
				if(inputsMatch) {
					$('button[type="submit"]', $this.closest('form')).removeAttr('disabled');
					$password_inputs.removeClass('has-error');
					$noMatchNote.hide();
				} else {
					$('button[type="submit"]', $this.closest('form')).attr('disabled', 'disabled');
					$password_inputs.addClass('has-error');
					$noMatchNote.show();
				}
			}
		}
		
		$('#password, #confirmation').on('input', passwordChange);
		$passwordOption.trigger('change');
		
		done();
	};
	
	// Return data to widget engine
	return module;
});
